% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvar-math.R
\name{diag,rvar-method}
\alias{diag,rvar-method}
\title{Matrix diagonals (including for random variables)}
\usage{
\S4method{diag}{rvar}(x = 1, nrow, ncol, names = TRUE)
}
\arguments{
\item{x}{(numeric,rvar) a matrix, vector, 1D array, missing, or a 1- or
2-dimensional \code{\link{rvar}}.}

\item{nrow, ncol}{optional dimensions for the result when \code{x} is
    not a matrix.}

\item{names}{(when \code{x} is a matrix) logical indicating if the
    resulting vector, the diagonal of \code{x}, should inherit
    \code{\link[base]{names}} from \code{dimnames(x)} if available.}
}
\value{
For \code{\link{rvar}}s, has two modes:
\enumerate{
\item \code{x} is a matrix-like \code{\link{rvar}}: it returns the diagonal as a vector-like \code{\link{rvar}}
\item \code{x} is a vector-like \code{\link{rvar}}: it returns a matrix-like \code{\link{rvar}} with \code{x} as
the diagonal and zero for off-diagonal entries.
}
}
\description{
Extract the diagonal of a matrix or construct a matrix, including random
matrices (2-dimensional \code{\link{rvar}}s). Makes \code{\link[base:diag]{base::diag()}} generic.
}
\details{
Makes \code{\link[base:diag]{base::diag()}} into a generic function. See that function's documentation
for usage with \code{\link{numeric}}s and for usage of \code{\link{diag<-}}, which is also supported
by \code{\link{rvar}}.
}
\examples{

# Sigma is a 3x3 covariance matrix
Sigma <- as_draws_rvars(example_draws("multi_normal"))$Sigma
Sigma

diag(Sigma)

diag(Sigma) <- 1:3
Sigma

diag(as_rvar(1:3))

}
\seealso{
\code{\link[base:diag]{base::diag()}}
}
