% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{pht}
\alias{pht}
\alias{summary.pht}
\alias{print.summary.pht}
\title{Hausman--Taylor Estimator for Panel Data}
\usage{
pht(
  formula,
  data,
  subset,
  na.action,
  model = c("ht", "am", "bms"),
  index = NULL,
  ...
)

\method{summary}{pht}(object, ...)

\method{print}{summary.pht}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  subset = NULL,
  ...
)
}
\arguments{
\item{formula}{a symbolic description for the model to be
estimated,}

\item{data}{a \code{data.frame},}

\item{subset}{see \code{\link[=lm]{lm()}} for \code{"plm"}, a character or
numeric vector indicating a subset of the table of coefficient
to be printed for \code{"print.summary.plm"},}

\item{na.action}{see \code{\link[=lm]{lm()}},}

\item{model}{one of \code{"ht"} for Hausman--Taylor, \code{"am"}
for Amemiya--MaCurdy and \code{"bms"} for
Breusch--Mizon--Schmidt,}

\item{index}{the indexes,}

\item{\dots}{further arguments.}

\item{object, x}{an object of class \code{"plm"},}

\item{digits}{digits,}

\item{width}{the maximum length of the lines in the print output,}
}
\value{
An object of class \code{c("pht", "plm", "panelmodel")}.

A \code{"pht"} object contains the same elements as \code{plm}
object, with a further argument called \code{varlist} which
describes the typology of the variables. It has \code{summary} and
\code{print.summary} methods.
}
\description{
The Hausman--Taylor estimator is an instrumental variable estimator without
external instruments (function deprecated).
}
\details{
\code{pht} estimates panels models using the Hausman--Taylor estimator,
Amemiya--MaCurdy estimator, or Breusch--Mizon--Schmidt estimator, depending
on the argument \code{model}. The model is specified as a two--part formula,
the second part containing the exogenous variables.
}
\note{
The function \code{pht} is deprecated. Please use function \code{plm}
to estimate Taylor--Hausman models like this with a three-part
formula as shown in the example:\cr \verb{plm(<formula>, random.method = "ht", model = "random", inst.method = "baltagi")}. The Amemiya--MaCurdy estimator and the
Breusch--Mizon--Schmidt estimator is computed likewise with
\code{plm}.
}
\examples{

## replicates Baltagi (2005, 2013), table 7.4; Baltagi (2021), table 7.5
## preferred way with plm()
data("Wages", package = "plm")
ht <- plm(lwage ~ wks + south + smsa + married + exp + I(exp ^ 2) + 
              bluecol + ind + union + sex + black + ed |
              bluecol + south + smsa + ind + sex + black |
              wks + married + union + exp + I(exp ^ 2), 
          data = Wages, index = 595,
          random.method = "ht", model = "random", inst.method = "baltagi")
summary(ht)

am <- plm(lwage ~ wks + south + smsa + married + exp + I(exp ^ 2) + 
              bluecol + ind + union + sex + black + ed |
              bluecol + south + smsa + ind + sex + black |
              wks + married + union + exp + I(exp ^ 2), 
          data = Wages, index = 595,
          random.method = "ht", model = "random", inst.method = "am")
summary(am)

## deprecated way with pht() for HT
#ht <- pht(lwage ~ wks + south + smsa + married + exp + I(exp^2) +
#          bluecol + ind + union + sex + black + ed | 
#          sex + black + bluecol + south + smsa + ind,
#          data = Wages, model = "ht", index = 595)
#summary(ht)
# deprecated way with pht() for AM
#am <- pht(lwage ~ wks + south + smsa + married + exp + I(exp^2) +
#          bluecol + ind + union + sex + black + ed | 
#          sex + black + bluecol + south + smsa + ind,
#          data = Wages, model = "am", index = 595)
#summary(am)


}
\references{
\insertCite{AMEM:MACU:86}{plm}

\insertCite{BALT:13}{plm}

\insertCite{BREU:MIZO:SCHM:89}{plm}

\insertCite{HAUS:TAYL:81}{plm}
}
\author{
Yves Croissant
}
\keyword{regression}
