% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_misc.R
\name{has.intercept}
\alias{has.intercept}
\alias{has.intercept.default}
\alias{has.intercept.formula}
\alias{has.intercept.Formula}
\alias{has.intercept.panelmodel}
\alias{has.intercept.plm}
\title{Check for the presence of an intercept in a formula or in a fitted
model}
\usage{
has.intercept(object, ...)

\method{has.intercept}{default}(object, data = NULL, ...)

\method{has.intercept}{formula}(object, data = NULL, ...)

\method{has.intercept}{Formula}(object, rhs = NULL, data = NULL, ...)

\method{has.intercept}{panelmodel}(object, ...)

\method{has.intercept}{plm}(object, rhs = 1L, ...)
}
\arguments{
\item{object}{a \code{formula}, a \code{Formula} or a fitted model (of class
\code{plm} or \code{panelmodel}),}

\item{\dots}{further arguments.}

\item{data}{default is \code{NULL} and only needs to be changes to a data set if
the formula contains a dot (\code{.}) to allow evaluation of the dot,}

\item{rhs}{an integer (length > 1 is possible), indicating the parts of right
hand sides of the formula to be evaluated for the presence of an
intercept or \code{NULL} for all parts of the right hand side
(relevant for the \code{Formula} and the \code{plm} methods),}
}
\value{
a logical
}
\description{
The presence of an intercept is checked using the formula which is
either provided as the argument of the function or extracted from
a fitted model.
}
