% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tool_ercomp.R
\name{ercomp}
\alias{ercomp}
\alias{ercomp.plm}
\alias{ercomp.pdata.frame}
\alias{ercomp.formula}
\alias{print.ercomp}
\title{Estimation of the error components}
\usage{
ercomp(object, ...)

\method{ercomp}{plm}(object, ...)

\method{ercomp}{pdata.frame}(
  object,
  effect = c("individual", "time", "twoways", "nested"),
  method = NULL,
  models = NULL,
  dfcor = NULL,
  index = NULL,
  ...
)

\method{ercomp}{formula}(
  object,
  data,
  effect = c("individual", "time", "twoways", "nested"),
  method = NULL,
  models = NULL,
  dfcor = NULL,
  index = NULL,
  ...
)

\method{print}{ercomp}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{a \code{formula} or a \code{plm} object,}

\item{\dots}{further arguments.}

\item{effect}{the effects introduced in the model, see \code{\link[=plm]{plm()}} for
details,}

\item{method}{method of estimation for the variance components, see
\code{\link[=plm]{plm()}} for details,}

\item{models}{the models used to estimate the variance components
(an alternative to the previous argument),}

\item{dfcor}{a numeric vector of length 2 indicating which degree
of freedom should be used,}

\item{index}{the indexes,}

\item{data}{a \code{data.frame},}

\item{x}{an \code{ercomp} object,}

\item{digits}{digits,}
}
\value{
An object of class \code{"ercomp"}: a list containing \itemize{
\item \code{sigma2} a named numeric with estimates of the variance
components, \item \code{theta} contains the parameter(s) used for
the transformation of the variables: For a one-way model, a
numeric corresponding to the selected effect (individual or
time); for a two-ways model a list of length 3 with the
parameters. In case of a balanced model, the numeric has length
1 while for an unbalanced model, the numerics' length equal the
number of observations. }
}
\description{
This function enables the estimation of the variance components of a panel
model.
}
\examples{

data("Produc", package = "plm")
# an example of the formula method
ercomp(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc,
       method = "walhus", effect = "time")
# same with the plm method
z <- plm(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp,
         data = Produc, random.method = "walhus",
         effect = "time", model = "random")
ercomp(z)
# a two-ways model
ercomp(log(gsp) ~ log(pcap) + log(pc) + log(emp) + unemp, data = Produc,
       method = "amemiya", effect = "twoways")

}
\references{
\insertRef{AMEM:71}{plm}

\insertRef{NERLO:71}{plm}

\insertRef{SWAM:AROR:72}{plm}

\insertRef{WALL:HUSS:69}{plm}
}
\seealso{
\code{\link[=plm]{plm()}} where the estimates of the variance components are
used if a random effects model is estimated
}
\author{
Yves Croissant
}
\keyword{regression}
