% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cronbachs_alpha.R
\name{cronbachs_alpha}
\alias{cronbachs_alpha}
\title{Cronbach's Alpha for Items or Scales}
\usage{
cronbachs_alpha(x, ...)
}
\arguments{
\item{x}{A matrix or a data frame.}

\item{...}{Currently not used.}
}
\value{
The Cronbach's Alpha value for \code{x}.
}
\description{
Compute various measures of internal consistencies
for tests or item-scales of questionnaires.
}
\details{
The Cronbach's Alpha value for \code{x}. A value closer to 1
indicates greater internal consistency, where usually following
rule of thumb is applied to interpret the results:
\ifelse{html}{\out{&alpha;}}{\eqn{\alpha}{alpha}} < 0.5 is unacceptable,
0.5 < \ifelse{html}{\out{&alpha;}}{\eqn{\alpha}{alpha}} < 0.6 is poor,
0.6 < \ifelse{html}{\out{&alpha;}}{\eqn{\alpha}{alpha}} < 0.7 is questionable,
0.7 < \ifelse{html}{\out{&alpha;}}{\eqn{\alpha}{alpha}} < 0.8 is acceptable,
and everything > 0.8 is good or excellent.
}
\examples{
data(mtcars)
x <- mtcars[, c("cyl", "gear", "carb", "hp")]
cronbachs_alpha(x)
}
\references{
Bland, J. M., and Altman, D. G. Statistics notes: Cronbach's
alpha. BMJ 1997;314:572. 10.1136/bmj.314.7080.572
}
