% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_attribute_data.R
\name{write_attribute_data}
\alias{write_attribute_data}
\title{Write attribute data to NetCDF-CF}
\usage{
write_attribute_data(
  nc_file,
  att_data,
  instance_dim_name = "instance",
  units = rep("unknown", ncol(att_data)),
  overwrite = FALSE
)
}
\arguments{
\item{nc_file}{\code{character} file path to the nc file to be created. 
If adding to a file, it must already have the named instance dimension.}

\item{att_data}{\code{data.frame} with instances as columns and attributes as rows.}

\item{instance_dim_name}{\code{character} name for the instance dimension. Defaults to "instance"}

\item{units}{\code{character} vector with units for each column of att_data. Defaults to "unknown" for all.}

\item{overwrite}{boolean overwrite existing file? Will append if FALSE.}
}
\description{
Creates a NetCDF file with an instance dimension, and any attributes from a data frame. 
Use to create the start of a NetCDF-DSG file. One character length dimension is created
long enough to contain the longest provided character string.
This function does not implement any CF convention attributes or standard names.
Any columns of class date will be converted to character.
}
\examples{
sample_data <- sf::st_set_geometry(sf::read_sf(system.file("shape/nc.shp", 
                                                           package = "sf")), 
                                   NULL)
example_file <-write_attribute_data(tempfile(), sample_data,
                                    units = rep("unknown", ncol(sample_data)))

try({
  ncdump <- system(paste("ncdump -h", example_file), intern = TRUE)
  cat(ncdump ,sep = "\n")
}, silent = TRUE)

}
