% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_timeseries_dsg.R
\name{read_timeseries_dsg}
\alias{read_timeseries_dsg}
\title{Read NetCDF-CF timeSeries featuretype}
\usage{
read_timeseries_dsg(nc_file)
}
\arguments{
\item{nc_file}{character file path to the nc file to be read.}
}
\value{
list containing the contents of the NetCDF file.
}
\description{
This function reads a timeseries discrete sampling geometry NetCDF file and 
returns a list containing the file's contents.
}
\details{
The current implementation checks several NetCDF-CF specific conventions prior to attempting to 
read the file. The Conventions and featureType global attributes are checked but not
strictly required. 

Variables with standard_name and/or cf_role of station_id and/or timeseries_id are 
searched for to indicate which variable is the 'timeseries identifier'. The function stops 
if one is not found.

All variables are introspected for a coordinates attribute. This attribute is used to determine
which variables are coordinate variables. If none are found an attempt to infer data 
variables by time and timeseries_id dimensions is made.

The coordinates variables are introspected and their standard_names used to determine
which coordinate they are. Lat, lon, and time are required, height is not. 

Variables with a coordinates attribute are assumed to be the 'data variables'.

Data variables are traversed and their metadata and data content put into lists within the main
response list.

See the timeseries vignette for more information.
}
\references{
http://www.unidata.ucar.edu/software/thredds/current/netcdf-java/reference/FeatureDatasets/CFpointImplement.html
}
