% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alter.r
\name{seq_mnsl}
\alias{seq_mnsl}
\title{Generate a sequence of Munsell colours}
\usage{
seq_mnsl(from, to, n, fix = FALSE)
}
\arguments{
\item{from}{character string of first Munsell colour}

\item{to}{character string of last Munsell colour}

\item{n}{number of colours in sequence}

\item{fix}{Should colours outside of the gamut be fixed? 
Passed on to \code{\link{fix_mnsl}}}
}
\value{
character vector of Munsell colours
}
\description{
Generates a sequence of Munsell colours.  The sequence is generated by 
finding the closest munsell colours to a equidistant sequence of colours in  #' LUV space.
}
\examples{
seq_mnsl("5R 2/4", "5R 5/16", 4)
plot_mnsl(seq_mnsl("5R 2/4", "5R 5/16", 4))
plot_mnsl(seq_mnsl("5R 5/6", 
  complement("5R 5/6"), 5))
}

