% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowIQRs.R
\name{rowIQRs}
\alias{rowIQRs}
\alias{colIQRs}
\alias{iqr}
\title{Estimates of the interquartile range for each row (column) in a matrix}
\usage{
rowIQRs(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

colIQRs(x, rows = NULL, cols = NULL, na.rm = FALSE, ...,
  useNames = TRUE)

iqr(x, idxs = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{x}{An NxK \code{\link[base]{matrix}} or, if \code{dim.} is specified,
an N * K \code{\link[base]{vector}}.}

\item{rows}{A \code{\link[base]{vector}} indicating subset of rows to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{cols}{A \code{\link[base]{vector}} indicating subset of columns to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
excluded.}

\item{...}{Additional arguments passed to \code{\link{rowQuantiles}}()
(\code{colQuantiles()}).}

\item{useNames}{If \code{\link[base:logical]{TRUE}} (default), names
attributes of the result are set, otherwise not.}

\item{idxs}{A \code{\link[base]{vector}} indicating subset of elements to
operate over. If \code{\link[base]{NULL}}, no subsetting is done.}
}
\value{
Returns a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
length N (K).
}
\description{
Estimates of the interquartile range for each row (column) in a matrix.
}
\section{Missing values}{
 Contrary to \code{\link[stats]{IQR}}, which gives
an error if there are missing values and \code{na.rm = FALSE}, \code{iqr()}
and its corresponding row and column-specific functions return
\code{\link[base]{NA}}_real_.
}

\examples{
set.seed(1)

x <- matrix(rnorm(50 * 40), nrow = 50, ncol = 40)
str(x)

# Row IQRs
q <- rowIQRs(x)
print(q)
q0 <- apply(x, MARGIN = 1, FUN = IQR)
stopifnot(all.equal(q0, q))

# Column IQRs
q <- colIQRs(x)
print(q)
q0 <- apply(x, MARGIN = 2, FUN = IQR)
stopifnot(all.equal(q0, q))
}
\seealso{
See \code{\link[stats]{IQR}}.  See \code{\link{rowSds}}().
}
\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
