% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probabilistic.R
\name{meanFirstPassageTime}
\alias{meanFirstPassageTime}
\title{Mean First Passage Time for irreducible Markov chains}
\usage{
meanFirstPassageTime(object, destination)
}
\arguments{
\item{object}{the markovchain object}

\item{destination}{a character vector representing the states respect to
which we want to compute the mean first passage time. Empty by default}
}
\value{
a Matrix of the same size with the average first passage times if
  destination is empty, a vector if destination is not
}
\description{
Given an irreducible (ergodic) markovchain object, this function
  calculates the expected number of steps to reach other states
}
\details{
For an ergodic Markov chain it computes: 
\itemize{ 
  \item If destination is empty, the average first time (in steps) that takes
  the Markov chain to go from initial state i to j. (i, j) represents that 
  value in case the Markov chain is given row-wise, (j, i) in case it is given
  col-wise. 
  \item If destination is not empty, the average time it takes us from the 
  remaining states to reach the states in \code{destination} 
}
}
\examples{
m <- matrix(1 / 10 * c(6,3,1,
                       2,3,5,
                       4,1,5), ncol = 3, byrow = TRUE)
mc <- new("markovchain", states = c("s","c","r"), transitionMatrix = m)
meanFirstPassageTime(mc, "r")


# Grinstead and Snell's "Oz weather" worked out example
mOz <- matrix(c(2,1,1,
                2,0,2,
                1,1,2)/4, ncol = 3, byrow = TRUE)

mcOz <- new("markovchain", states = c("s", "c", "r"), transitionMatrix = mOz)
meanFirstPassageTime(mcOz)

}
\references{
C. M. Grinstead and J. L. Snell. Introduction to Probability.
American Mathematical Soc., 2012.
}
\author{
Toni Giorgino, Ignacio Cordón
}
