% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{st_transform_proj}
\alias{st_transform_proj}
\alias{st_transform_proj.sfc}
\alias{st_transform_proj.sf}
\alias{st_transform_proj.sfg}
\title{Transform or convert coordinates of simple features directly with Proj.4 (bypassing GDAL)}
\usage{
st_transform_proj(x, crs, ...)

\method{st_transform_proj}{sfc}(x, crs, ...)

\method{st_transform_proj}{sf}(x, crs, ...)

\method{st_transform_proj}{sfg}(x, crs, ...)
}
\arguments{
\item{x}{object of class sf, sfc or sfg}

\item{crs}{character; target CRS, or, in case of a length 2 character vector, source and target CRS}

\item{...}{ignored}
}
\description{
Transform or convert coordinates of simple features directly with Proj.4 (bypassing GDAL)
}
\details{
Transforms coordinates of object to new projection, using PROJ directly rather than the GDAL API used by \link[sf]{st_transform}.

If \code{crs} is a single CRS, it forms the target CRS, and in that case the source CRS is obtained as \code{st_crs(x)}. Since this presumes that the source CRS is accepted by GDAL (which is not always the case), a second option is to specify the source and target CRS as two proj4strings in argument \code{crs}. In the latter case, \code{st_crs(x)} is ignored and may well be \code{NA}.

The \code{st_transform_proj} method for \code{sfg} objects assumes that the CRS of the object is available as an attribute of that name.
}
\examples{
library(sf)
p1 = st_point(c(7,52))
p2 = st_point(c(-30,20))
sfc = st_sfc(p1, p2, crs = 4326)
sfc
st_transform_proj(sfc, "+proj=wintri")
library(sf)
nc = st_read(system.file("shape/nc.shp", package="sf"))
st_transform_proj(nc[1,], "+proj=wintri +over")
st_transform_proj(structure(p1, proj4string = "+init=epsg:4326"), "+init=epsg:3857")
}
