% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\docType{package}
\name{Luminescence-package}
\alias{Luminescence-package}
\alias{Luminescence}
\title{Comprehensive Luminescence Dating Data Analysis}
\description{
\if{html}{
\figure{RL_Logo.png}{options: width="50px" alt="r-luminescence.org"}\cr
\emph{R Luminescence Developer Team}
}
}
\details{
A collection of various R functions for the purpose of Luminescence dating
data analysis. This includes, amongst others, data import, export,
application of age models, curve deconvolution, sequence analysis and
plotting of equivalent dose distributions.

\strong{Full list of authors and contributors} (alphabetic order)

\tabular{ll}{
Martin Autzen \tab \emph{DTU NUTECH Center for Nuclear Technologies} \cr
Christoph Burow \tab \emph{University of Cologne, Germany}* \cr
Claire Christophe \tab \emph{IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne, France} \cr
Michael Dietze \tab \emph{GFZ Helmholtz Centre Potsdam, Germany} \cr
Julie Durcan \tab \emph{University of Oxford, United Kingdom} \cr
Pierre Guibert \tab \emph{IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne, France} \cr
Manfred Fischer\tab \emph{University of Bayreuth, Germany} \cr
Margret C. Fuchs \tab \emph{Helmholtz-Zentrum Dresden-Rossendorf, Helmholtz-Institute Freiberg for Resource Technology, Freiberg, Germany} \cr
Johannes Friedrich \tab \emph{Chair of Geomorphology, University of Bayreuth, Germany} \cr
Guillaume Guérin \tab \emph{IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne, France} \cr
Georgina E. King \tab \emph{University of Lausanne, Switzerland} \cr
Sebastian Kreutzer \tab *Department of Geography & Earth Sciences, Aberystwyth University, United Kingdom * \cr
Norbert Mercier \tab \emph{IRAMAT-CRP2A, UMR 5060, CNRS - Université Bordeaux Montaigne, France} \cr
Svenja Riedesel \tab \emph{Aberystwyth University, United Kingdom} \cr
Christoph Schmidt \tab \emph{Chair of Geomorophology, University of Bayreuth, Germany} \cr
Rachel K. Smedley \tab \emph{Liverpool University, United Kingdom} \cr
Anne Philippe \tab  \emph{Universite de Nantes and ANJA INRIA, Rennes, France} \cr
Antoine Zink \tab \emph{C2RMF, Palais du Louvre, Paris, France}
}

\strong{Supervisor of the initial version in 2012}

Markus Fuchs, Justus-Liebig-University Giessen, Germany

\strong{Support contact}

\email{developers@r-luminescence.org}

We may further encourage the usage of our support forum. For this please
visit our project website (link below).

\strong{Bug reporting}
\itemize{
\item \email{developers@r-luminescence.org} or
\item \url{https://github.com/R-Lum/Luminescence/issues}
}

\strong{Project website}
\itemize{
\item \url{http://www.r-luminescence.org}
}

\strong{Project source code repository}
\itemize{
\item \url{https://github.com/R-Lum/Luminescence}
}

\strong{Related package projects}
\itemize{
\item \url{https://cran.r-project.org/package=RLumShiny}
\item \url{https://cran.r-project.org/package=RLumModel}
}

\strong{Package maintainer}

Sebastian Kreutzer, Department of of Geography & Earth Sciences, Aberystwyth University, United Kingdom,\cr
\email{sebastian.kreutzer@u-bordeaux-montaigne.fr}

\strong{Funding}

Cooperation and personal exchange between the developers is gratefully
funded by the DFG (SCHM 3051/3-1) in the framework of the program
"Scientific Networks". Project title: "RLum.Network: Ein
Wissenschaftsnetzwerk zur Analyse von Lumineszenzdaten mit R" (2014-2018)

Between 2014--2019, the work of Sebastian Kreutzer as maintainer of the package was supported
by LabEx LaScArBxSK (ANR - n. ANR-10-LABX-52).
}
\references{
Dietze, M., Kreutzer, S., Fuchs, M.C., Burow, C., Fischer, M.,
Schmidt, C., 2013. A practical guide to the R package Luminescence.
Ancient TL, 31 (1), 11-18.

Dietze, M., Kreutzer, S., Burow, C., Fuchs, M.C., Fischer, M., Schmidt, C., 2016. The abanico plot:
visualising chronometric data with individual standard errors. Quaternary Geochronology 31, 1-7.
https://doi.org/10.1016/j.quageo.2015.09.003

Fuchs, M.C., Kreutzer, S., Burow, C., Dietze, M., Fischer, M., Schmidt, C.,
Fuchs, M., 2015. Data processing in luminescence dating analysis: An
exemplary workflow using the R package 'Luminescence'. Quaternary
International, 362,8-13. https://doi.org/10.1016/j.quaint.2014.06.034

Kreutzer, S., Schmidt, C., Fuchs, M.C., Dietze, M., Fischer, M., Fuchs, M.,
2012. Introducing an R package for luminescence dating analysis. Ancient TL,
30 (1), 1-8.

Mercier, N., Kreutzer, S., Christophe, C., Guérin, G., Guibert, P., Lahaye, C., Lanos, P., Philippe, A.,
Tribolo, C., 2016. Bayesian statistics in luminescence dating: The ’baSAR’-model and its
implementation in the R package ’Luminescence’. Ancient TL 34 (2), 14-21.

Smedley, R.K., 2015. A new R function for the Internal External Uncertainty (IEU) model.
Ancient TL, 33 (1), 16-21.

King, E.G., Burow, C., Roberts, H., Pearce, N.J.G., 2018. Age determination
using feldspar: evaluating fading-correction model performance. Radiation Measurements 119, 58-73.
https://doi.org/10.1016/j.radmeas.2018.07.013
}
\keyword{package}
