% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arg.R
\name{deprecated}
\alias{deprecated}
\title{Mark an argument as deprecated}
\usage{
deprecated()
}
\description{
Signal deprecated argument by using self-documenting sentinel
\code{deprecated()} as default argument. It returns
\code{\link[rlang:missing_arg]{rlang::missing_arg()}}, so you can test whether the user supplied
the argument with \code{\link[rlang:is_missing]{rlang::is_missing()}} (see examples).
}
\section{Magical defaults}{


We recommend importing \code{lifecycle::deprecated()} in your namespace
and use it without the namespace qualifier.

In general, we \href{https://principles.tidyverse.org/def-magical.html}{advise against} such
magical defaults, i.e. defaults that cannot be evaluated by the
user. In the case of \code{deprecated()}, the trade-off is worth it
because the meaning of this default is obvious and there is no
reason for the user to call \code{deprecated()} themselves.
}

\examples{
foobar_adder <- function(foo, bar, baz = deprecated()) {
  # Check if user has supplied `baz` instead of `bar`
  if (!rlang::is_missing(baz)) {

    # Signal the deprecation to the user
    deprecate_warn("1.0.0", "foo::bar_adder(baz = )", "foo::bar_adder(bar = )")

    # Deal with the deprecated argument for compatibility
    bar <- baz
  }

  foo + bar
}

foobar_adder(1, 2)
foobar_adder(1, baz = 2)

}
