% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zsolve.R
\name{zsolve}
\alias{zsolve}
\title{Solve a linear system over the integers}
\usage{
zsolve(mat, rel, rhs, sign, lat, lb, ub, dir = tempdir(), quiet = TRUE,
  shell = FALSE, ...)
}
\arguments{
\item{mat}{The A matrix (see the 4ti2 documentation or examples)}

\item{rel}{A vector of "<" or ">" relations}

\item{rhs}{The right hand side b}

\item{sign}{The signs of the individual}

\item{lat}{A lattice basis (instead of a matrix)}

\item{lb}{Lower bounds on columns}

\item{ub}{Upper bounds on columns}

\item{dir}{Directory to place the files in, without an ending /}

\item{quiet}{If FALSE, messages the 4ti2 output}

\item{shell}{Messages the shell code used to do the computation}

\item{...}{Additional arguments to pass to the function}
}
\value{
The configuration matrix of the model provided
}
\description{
zsolve runs 4ti2's zsolve program to compute the configuration matrix A
corresponding to graphical statistical models given by a simplicial complex
and levels on the nodes.
}
\examples{

if (has_4ti2()) {

mat <- rbind(
  c( 1, -1),
  c(-3,  1),
  c( 1,  1)
)
rel <- c("<", "<", ">")
rhs <- c(2, 1, 1)
sign <- c(0, 1)

zsolve(mat, rel, rhs, sign)
zsolve(mat, rel, rhs, sign, quiet = FALSE)
zsolve(mat, rel, rhs, sign, shell = TRUE)

zsolve(mat, rel, rhs, sign, p = "gmp", quiet = FALSE)

}


}
