% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header_separate.R
\name{header_separate}
\alias{header_separate}
\title{Separate table headers and add additional header rows based on grouping}
\usage{
header_separate(kable_input, sep = "[^[:alnum:]]+", ...)
}
\arguments{
\item{kable_input}{Output of \code{knitr::kable()} with \code{format} specified}

\item{sep}{A regular expression separator between groups. The default value
is a regular expression that matches any sequence of non-alphanumeric values.}

\item{...}{Additional parameters passed to do.call.}
}
\description{
When you create a summary table for either model or basic
summary stats in R, you usually end up having column names in the form of
"a_mean", "a_sd", "b_mean" and "b_sd". This function streamlines the process
of renaming these column names and adding extra header rows using
\code{add_header_above}.
}
