% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{aging.prefatt.game}
\alias{aging.prefatt.game}
\title{Generate an evolving random graph with preferential attachment and aging}
\usage{
aging.prefatt.game(
  n,
  pa.exp,
  aging.exp,
  m = NULL,
  aging.bin = 300,
  out.dist = NULL,
  out.seq = NULL,
  out.pref = FALSE,
  directed = TRUE,
  zero.deg.appeal = 1,
  zero.age.appeal = 0,
  deg.coef = 1,
  age.coef = 1,
  time.window = NULL
)
}
\arguments{
\item{n}{The number of vertices in the graph.}

\item{pa.exp}{The preferential attachment exponent, see the details below.}

\item{aging.exp}{The exponent of the aging, usually a non-positive number,
see details below.}

\item{m}{The number of edges each new vertex creates (except the very first
vertex). This argument is used only if both the \code{out.dist} and
\code{out.seq} arguments are NULL.}

\item{aging.bin}{The number of bins to use for measuring the age of
vertices, see details below.}

\item{out.dist}{The discrete distribution to generate the number of edges to
add in each time step if \code{out.seq} is NULL. See details below.}

\item{out.seq}{The number of edges to add in each time step, a vector
containing as many elements as the number of vertices. See details below.}

\item{out.pref}{Logical constant, whether to include edges not initiated by
the vertex as a basis of preferential attachment. See details below.}

\item{directed}{Logical constant, whether to generate a directed graph. See
details below.}

\item{zero.deg.appeal}{The degree-dependent part of the
\sQuote{attractiveness} of the vertices with no adjacent edges. See also
details below.}

\item{zero.age.appeal}{The age-dependent part of the \sQuote{attrativeness}
of the vertices with age zero. It is usually zero, see details below.}

\item{deg.coef}{The coefficient of the degree-dependent
\sQuote{attractiveness}. See details below.}

\item{age.coef}{The coefficient of the age-dependent part of the
\sQuote{attractiveness}. See details below.}

\item{time.window}{Integer constant, if NULL only adjacent added in the last
\code{time.windows} time steps are counted as a basis of the preferential
attachment. See also details below.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{aging.prefatt.game()} was renamed to \code{sample_pa_age()} to create a more
consistent API.
}
\keyword{internal}
