% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/http-put.r
\name{PUT}
\alias{PUT}
\title{Send PUT request to server.}
\usage{
PUT(
  url = NULL,
  config = list(),
  ...,
  body = NULL,
  encode = c("multipart", "form", "json", "raw"),
  handle = NULL
)
}
\arguments{
\item{url}{the url of the page to retrieve}

\item{config}{Additional configuration settings such as http
authentication (\code{\link[=authenticate]{authenticate()}}), additional headers
(\code{\link[=add_headers]{add_headers()}}), cookies (\code{\link[=set_cookies]{set_cookies()}}) etc.
See \code{\link[=config]{config()}} for full details and list of helpers.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc,
passed on to \code{\link[=modify_url]{modify_url()}}. Unnamed parameters will be combined
with \code{\link[=config]{config()}}.}

\item{body}{One of the following:
\itemize{
\item \code{FALSE}: No body. This is typically not used with \code{POST},
\code{PUT}, or \code{PATCH}, but can be useful if you need to send a
bodyless request (like \code{GET}) with \code{VERB()}.
\item \code{NULL}: An empty body
\item \code{""}: A length 0 body
\item \code{upload_file("path/")}: The contents of a file.  The mime
type will be guessed from the extension, or can be supplied explicitly
as the second argument to \code{upload_file()}
\item A character or raw vector: sent as is in body. Use
\code{\link[=content_type]{content_type()}} to tell the server what sort of data
you are sending.
\item A named list: See details for encode.
}}

\item{encode}{If the body is a named list, how should it be encoded? Can be
one of form (application/x-www-form-urlencoded), multipart,
(multipart/form-data), or json (application/json).

For "multipart", list elements can be strings or objects created by
\code{\link[=upload_file]{upload_file()}}. For "form", elements are coerced to strings
and escaped, use \code{I()} to prevent double-escaping. For "json",
parameters are automatically "unboxed" (i.e. length 1 vectors are
converted to scalars). To preserve a length 1 vector as a vector,
wrap in \code{I()}. For "raw", either a character or raw vector. You'll
need to make sure to set the \code{\link[=content_type]{content_type()}} yourself.}

\item{handle}{The handle to use with this request. If not
supplied, will be retrieved and reused from the \code{\link[=handle_pool]{handle_pool()}}
based on the scheme, hostname and port of the url. By default \pkg{httr}
requests to the same scheme/host/port combo. This substantially reduces
connection time, and ensures that cookies are maintained over multiple
requests to the same host. See \code{\link[=handle_pool]{handle_pool()}} for more
details.}
}
\description{
Send PUT request to server.
}
\examples{
\dontrun{
POST("http://httpbin.org/put")
PUT("http://httpbin.org/put")

b2 <- "http://httpbin.org/put"
PUT(b2, body = "A simple text string")
PUT(b2, body = list(x = "A simple text string"))
PUT(b2, body = list(y = upload_file(system.file("CITATION"))))
PUT(b2, body = list(x = "A simple text string"), encode = "json")
}
}
\seealso{
Other http methods: 
\code{\link{BROWSE}()},
\code{\link{DELETE}()},
\code{\link{GET}()},
\code{\link{HEAD}()},
\code{\link{PATCH}()},
\code{\link{POST}()},
\code{\link{VERB}()}
}
\concept{http methods}
