% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_port.R
\name{randomPort}
\alias{randomPort}
\title{Find an open TCP port}
\usage{
randomPort(min = 1024L, max = 49151L, host = "127.0.0.1", n = 20)
}
\arguments{
\item{min}{Minimum port number.}

\item{max}{Maximum port number.}

\item{host}{A string that is a valid IPv4 or IPv6 address that is owned by
this server, which the application will listen on. \code{"0.0.0.0"}
represents all IPv4 addresses and \code{"::/0"} represents all IPv6
addresses.}

\item{n}{Number of ports to try before giving up.}
}
\value{
A port that is available to listen on.
}
\description{
Finds a random available TCP port for listening on, within a specified range
of ports. The default range of ports to check is 1024 to 49151, which is the
set of TCP User Ports. This function automatically excludes some ports which
are considered unsafe by web browsers.
}
\examples{
\dontrun{
s <- startServer("127.0.0.1", randomPort(), list())
browseURL(paste0("http://127.0.0.1:", s$getPort()))

s$stop()
}

}
