% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{WebServer}
\alias{WebServer}
\title{WebServer class}
\description{
This class represents a web server running one application. Multiple servers
can be running at the same time.
}
\section{Methods}{


\describe{
\item{\code{initialize(host, port, app)}}{
Create a new \code{WebServer} object. \code{app} is an httpuv application
object as described in \code{\link{startServer}}.
}
\item{\code{getHost()}}{Return the value of \code{host} that was passed to
\code{initialize()}.
}
\item{\code{getPort()}}{Return the value of \code{port} that was passed to
\code{initialize()}.
}
\item{\code{stop()}}{Stops a running server.}
\item{\code{isRunning()}}{Returns TRUE if the server is currently running.}
\item{\code{getStaticPaths()}}{Returns a list of \code{\link{staticPath}}
objects for the server.
}
\item{\code{setStaticPath(..., .list = NULL)}}{Sets a static path for the
current server. Each static path can be given as a named argument, or as
an named item in \code{.list}. If there already exists a static path with
the same name, it will be replaced.
}
\item{\code{removeStaticPath(path)}}{Removes a static path with the given
name.
}
\item{\code{getStaticPathOptions()}}{Returns a list of default
\code{staticPathOptions} for the current server. Each static path will
use these options by default, but they can be overridden for each static
path.
}
\item{\code{setStaticPathOption(..., .list = NULL)}}{Sets one or more
static path options. Each option can be given as a named argument, or as
a named item in \code{.list}.
}
}
}

\seealso{
\code{\link{Server}} and \code{\link{PipeServer}}.
}
\keyword{internal}
\section{Super class}{
\code{\link[httpuv:Server]{httpuv::Server}} -> \code{WebServer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WebServer-new}{\code{WebServer$new()}}
\item \href{#method-WebServer-getHost}{\code{WebServer$getHost()}}
\item \href{#method-WebServer-getPort}{\code{WebServer$getPort()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="getStaticPathOptions"><a href='../../httpuv/html/Server.html#method-Server-getStaticPathOptions'><code>httpuv::Server$getStaticPathOptions()</code></a></span></li>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="getStaticPaths"><a href='../../httpuv/html/Server.html#method-Server-getStaticPaths'><code>httpuv::Server$getStaticPaths()</code></a></span></li>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="isRunning"><a href='../../httpuv/html/Server.html#method-Server-isRunning'><code>httpuv::Server$isRunning()</code></a></span></li>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="removeStaticPath"><a href='../../httpuv/html/Server.html#method-Server-removeStaticPath'><code>httpuv::Server$removeStaticPath()</code></a></span></li>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="setStaticPath"><a href='../../httpuv/html/Server.html#method-Server-setStaticPath'><code>httpuv::Server$setStaticPath()</code></a></span></li>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="setStaticPathOption"><a href='../../httpuv/html/Server.html#method-Server-setStaticPathOption'><code>httpuv::Server$setStaticPathOption()</code></a></span></li>
<li><span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="stop"><a href='../../httpuv/html/Server.html#method-Server-stop'><code>httpuv::Server$stop()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WebServer-new"></a>}}
\if{latex}{\out{\hypertarget{method-WebServer-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebServer$new(host, port, app, quiet = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WebServer-getHost"></a>}}
\if{latex}{\out{\hypertarget{method-WebServer-getHost}{}}}
\subsection{Method \code{getHost()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebServer$getHost()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WebServer-getPort"></a>}}
\if{latex}{\out{\hypertarget{method-WebServer-getPort}{}}}
\subsection{Method \code{getPort()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebServer$getPort()}\if{html}{\out{</div>}}
}

}
}
