% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_mime_type.R
\name{drive_mime_type}
\alias{drive_mime_type}
\title{Lookup MIME type}
\usage{
drive_mime_type(type = NULL)
}
\arguments{
\item{type}{Character. Google Drive file type, file extension, or MIME type.
Pass the sentinel \code{\link[=expose]{expose()}} if you want to get the full table used for
validation and lookup, i.e. all MIME types known to be relevant to the
Drive API.}
}
\value{
Character. MIME type.
}
\description{
This is a helper to determine which MIME type should be used
for a file. Three types of input are acceptable:
\itemize{
\item Native Google Drive file types. Important examples:
\itemize{
\item "document" for Google Docs
\item "folder" for folders
\item "presentation" for Google Slides
\item "spreadsheet" for Google Sheets
}
\item File extensions, such as "pdf", "csv", etc.
\item MIME types accepted by Google Drive (these are simply passed through).
}
}
\examples{
## get the mime type for Google Spreadsheets
drive_mime_type("spreadsheet")

## get the mime type for jpegs
drive_mime_type("jpeg")

## it's vectorized
drive_mime_type(c("presentation", "pdf", "image/gif"))

## see the internal tibble of MIME types known to the Drive API
drive_mime_type(expose())
}
