% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autodensity.R, R/autohistogram.R
\name{geom_autodensity}
\alias{geom_autodensity}
\alias{geom_autohistogram}
\title{A distribution geoms that fills the panel and works with discrete and continuous data}
\usage{
geom_autodensity(
  mapping = NULL,
  data = NULL,
  stat = "autodensity",
  position = "floatstack",
  ...,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  n = 512,
  trim = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_autohistogram(
  mapping = NULL,
  data = NULL,
  stat = "autobin",
  position = "floatstack",
  ...,
  bins = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_density} and \code{stat_density}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{bw}{The smoothing bandwidth to be used.
If numeric, the standard deviation of the smoothing kernel.
If character, a rule to choose the bandwidth, as listed in
\code{\link[stats:bandwidth]{stats::bw.nrd()}}.}

\item{adjust}{A multiplicate bandwidth adjustment. This makes it possible
to adjust the bandwidth while still using the a bandwidth estimator.
For example, \code{adjust = 1/2} means use half of the default bandwidth.}

\item{kernel}{Kernel. See list of available kernels in \code{\link[=density]{density()}}.}

\item{n}{number of equally spaced points at which the density is to be
estimated, should be a power of two, see \code{\link[=density]{density()}} for
details}

\item{trim}{If \code{FALSE}, the default, each density is computed on the
full range of the data. If \code{TRUE}, each density is computed over the
range of that group: this typically means the estimated x values will
not line-up, and hence you won't be able to stack density values.
This parameter only matters if you are displaying multiple densities in
one plot or if you are manually adjusting the scale limits.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{bins}{Number of bins. Overridden by \code{binwidth}. Defaults to 30.}
}
\description{
These versions of the histogram and density geoms have been designed
specifically for diagonal plotting with \code{\link[=facet_matrix]{facet_matrix()}}. They differ from
\code{\link[ggplot2:geom_histogram]{ggplot2::geom_histogram()}} and \code{\link[ggplot2:geom_density]{ggplot2::geom_density()}} in that they
defaults to mapping \code{x} and \code{y} to \code{.panel_x} and \code{.panel_y} respectively,
they ignore the y scale of the panel and fills it out, and they work for both
continuous and discrete x scales.
}
\examples{
# A matrix plot with a mix of discrete and continuous variables
p <- ggplot(mpg) +
  geom_autopoint() +
  facet_matrix(vars(drv:fl), layer.diag = 2, grid.y.diag = FALSE)
p

# Diagonal histograms
p + geom_autohistogram()

# Diagonal density distributions
p + geom_autodensity()

# You can use them like regular layers with groupings etc
p + geom_autodensity(aes(colour = drv, fill = drv),
                     alpha = 0.4)
}
\seealso{
\link{facet_matrix} for creating matrix grids
}
