% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usage.R
\name{usage}
\alias{usage}
\title{Show the usage of a function}
\usage{
usage(
  FUN,
  width = getOption("width"),
  tidy = TRUE,
  output = TRUE,
  indent.by.FUN = FALSE,
  fail = c("warn", "stop", "none")
)
}
\arguments{
\item{FUN}{The function name.}

\item{width}{The width of the output.}

\item{tidy}{Whether to reformat the usage code.}

\item{output}{Whether to print the output to the console (via
\code{\link{cat}()}).}

\item{indent.by.FUN}{Whether to indent subsequent lines by the width of the
function name (see \dQuote{Details}).}

\item{fail}{A character string that represents the action taken when the
width constraint is unfulfillable. "warn" and "stop" will signal warnings
and errors, while "none" will do nothing.}
}
\value{
Reformatted usage code of a function, in character strings
  (invisible).
}
\description{
Print the reformatted usage of a function. The arguments of the function are
searched by \code{\link{argsAnywhere}()}, so the function can be either
exported or non-exported from a package. S3 methods will be marked.
}
\details{
Line breaks in the output occur between arguments. In particular,
  default values of arguments will not be split across lines.

  When \code{indent.by.FUN} is \code{FALSE}, indentation is set by the option
  \code{\link{getOption}("formatR.indent", 4L)}, the default value of the
  \code{indent} argument of \code{\link{tidy_source}()}.
}
\examples{
library(formatR)
usage(var)

usage(plot)

usage(plot.default)  # default method
usage("plot.lm")  # on the 'lm' class

usage(usage)

usage(barplot.default, width = 60)  # output lines have 60 characters or less

# indent by width of 'barplot('
usage(barplot.default, width = 60, indent.by.FUN = TRUE)

\dontrun{
# a warning is raised because the width constraint is unfulfillable
usage(barplot.default, width = 30)
}
}
\seealso{
\code{\link{tidy_source}()}
}
