% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ets.R, R/ggplot.R
\name{plot.ets}
\alias{plot.ets}
\alias{autoplot.ets}
\title{Plot components from ETS model}
\usage{
\method{plot}{ets}(x, ...)

\method{autoplot}{ets}(object, range.bars = NULL, ...)
}
\arguments{
\item{x}{Object of class \dQuote{ets}.}

\item{...}{Other plotting parameters to affect the plot.}

\item{object}{Object of class \dQuote{ets}. Used for ggplot graphics (S3
method consistency).}

\item{range.bars}{Logical indicating if each plot should have a bar at its
right side representing relative size. If NULL, automatic selection takes
place.}
}
\value{
None. Function produces a plot
}
\description{
Produces a plot of the level, slope and seasonal components from an ETS
model.
}
\details{
\code{autoplot} will produce an equivalent plot as a ggplot object.
}
\examples{

fit <- ets(USAccDeaths)
plot(fit)
plot(fit,plot.type="single",ylab="",col=1:3)

library(ggplot2)
autoplot(fit)

}
\seealso{
\code{\link{ets}}
}
\author{
Rob J Hyndman & Mitchell O'Hara-Wild
}
\keyword{hplot}
