% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_colour.R
\name{convert_colour}
\alias{convert_colour}
\title{Convert between colour spaces}
\usage{
convert_colour(colour, from, to, white_from = "D65", white_to = white_from)
}
\arguments{
\item{colour}{A numeric matrix (or an object coercible to one) with colours
encoded in the rows and the different colour space values in the columns. For
all colourspaces except \code{'cmyk'} this will mean a matrix with three columns -
for \code{'cmyk'} it means four columns.}

\item{from, to}{The input and output colour space. Allowed values are: \code{"cmy"},
\code{"cmyk"}, \code{"hsl"}, \code{"hsb"}, \code{"hsv"}, \code{"lab"} (CIE L*ab), \code{"hunterlab"}
(Hunter Lab), \code{"oklab"}, \code{"lch"} (CIE Lch(ab) / polarLAB), \code{"luv"},
\code{"rgb"} (sRGB), \code{"xyz"}, \code{"yxy"} (CIE xyY), \code{"hcl"} (CIE Lch(uv) / polarLuv),
or \code{"oklch"} (Polar form of oklab)}

\item{white_from, white_to}{The white reference of the from and to colour
space. Will only have an effect for relative colour spaces such as Lab and
luv. Any value accepted by \code{\link[=as_white_ref]{as_white_ref()}} allowed.}
}
\value{
A numeric matrix with the same number of rows as \code{colour} and either
3 or 4 columns depending on the value of \code{to}. If \code{colour} is given as a
\code{data.frame} the output will be a data.frame as well
}
\description{
This function lets you convert between different representations of colours.
The API is reminiscent of \code{\link[grDevices:convertColor]{grDevices::convertColor()}}, but the performance is
much better. It is not assured that \code{grDevices::convertColor()} and
\code{convert_colour()} provide numerically equivalent conversion at 16bit level as
the formula used are potentially slightly different. For all intend and
purpose, the resulting colours will be equivalent though.
}
\note{
This function and \code{\link[=convertColor]{convertColor()}} are not
numerically equivalent due to rounding errors, but for all intend and purpose
they give the same results.
}
\section{Handling of non-finite and out of bounds values}{

\code{NA}, \code{NaN}, \code{-Inf}, and \code{Inf} are treated as invalid input and will result
in \code{NA} values for the colour. If a given colourspace has finite bounds in
some of their channels, the input will be capped before conversion, and the
output will be capped before returning, so that both input and output colours
are valid colours in their respective space. This means that converting back
and forth between two colourspaces may result in a change in the colour if
the gamut of one of the spaces is less than the other.
}

\examples{
spectrum <- decode_colour(rainbow(10))
spec_lab <- convert_colour(spectrum, 'rgb', 'lab')
spec_lab

# Convert between different white references
convert_colour(spec_lab, 'lab', 'lab', white_from = 'D65', white_to = 'F10')

}
\seealso{
\code{\link[grDevices:convertColor]{grDevices::convertColor()}}, \code{\link[grDevices:col2rgb]{grDevices::col2rgb()}}
}
