% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_condition_pr_matrix.R
\name{permutations_to_condition_pr_mat}
\alias{permutations_to_condition_pr_mat}
\title{Builds condition probability matrices for Horvitz-Thompson estimation from
permutation matrix}
\usage{
permutations_to_condition_pr_mat(permutations)
}
\arguments{
\item{permutations}{A matrix where the rows are units and the columns are
different treatment permutations; treated units must be represented with a
1 and control units with a 0}
}
\value{
a numeric 2n*2n matrix of marginal and joint condition treatment
probabilities to be passed to the \code{condition_pr_mat} argument of
\code{\link{horvitz_thompson}}.
}
\description{
Builds condition probability matrices for Horvitz-Thompson estimation from
permutation matrix
}
\details{
This function takes a matrix of permutations, for example from
the \code{\link[randomizr]{obtain_permutation_matrix}} function in
\pkg{randomizr} or through simulation and returns a 2n*2n matrix that can
be used to fully specify the design for \code{\link{horvitz_thompson}}
estimation. You can read more about these matrices in the documentation for
the \code{\link{declaration_to_condition_pr_mat}} function.

This is done by passing this matrix to the \code{condition_pr_mat} argument
of
}
\examples{

# Complete randomization
perms <- replicate(1000, sample(rep(0:1, each = 50)))
comp_pr_mat <- permutations_to_condition_pr_mat(perms)

# Arbitrary randomization
possible_treats <- cbind(
  c(1, 1, 0, 1, 0, 0, 0, 1, 1, 0),
  c(0, 1, 1, 0, 1, 1, 0, 1, 0, 1),
  c(1, 0, 1, 1, 1, 1, 1, 0, 0, 0)
)
arb_pr_mat <- permutations_to_condition_pr_mat(possible_treats)
# Simulating a column to be realized treatment
z <- possible_treats[, sample(ncol(possible_treats), size = 1)]
y <- rnorm(nrow(possible_treats))
horvitz_thompson(y ~ z, condition_pr_mat = arb_pr_mat)

}
\seealso{
\code{\link[randomizr]{declare_ra}},
\code{\link{declaration_to_condition_pr_mat}}
}
