% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiv.R
\name{mvregrid}
\alias{mvregrid}
\title{Multivariate regridding}
\usage{
mvregrid(object, newname = "component", newlevs = seq_len(ncol(newy)),
  mult.name = names(levels)[length(levels)], fcn = paste0(tran, "Inv"),
  ...)
}
\arguments{
\item{object}{An \code{emmGrid} object}

\item{newname}{The name to give to the newly created multivariate factor}

\item{newlevs}{Character levels of the newly created factor (must conform to
the number of columns created by \code{fcn})}

\item{mult.name}{The name of the multivariate factor to be transformed.
By default, we use the last factor}

\item{fcn}{The multivariate function to apply. If character, we look for it 
in the namespace of the \pkg{compositions} package.}

\item{...}{Additional arguments passed to \code{fcn}}
}
\value{
A new \code{emmGrid} object with the newly created factor as its last factor
}
\description{
This function is similar to \code{\link{regrid}} except it performs a
multivariate transformation. This is useful, for instance, in multivariate
models that have a compositional response.
}
\details{
If a multivariate response transformation was used in fitting the model,
its name is auto-detected, and in that case we need not specify \code{fcn}
as long as its inverse can be found in the namespace of the \pkg{compositions}
package. (That package need not be installed unless \code{fcn} is a character 
value.) For some such models, auto-detection process throws a
warning message, especially if \code{cbind} is also present in the model
formula.

Currently, no bias-adjustment option is available.
}
\examples{
if(requireNamespace("compositions"))
    emm_example("mvregrid")
    # Use emm_example("mvregrid", list = TRUE) # to see just the code

}
