% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{pigs}
\alias{pigs}
\title{Effects of dietary protein on free plasma leucine concentration in pigs}
\format{
A data frame with 29 observations and 3 variables:
\describe{
  \item{source}{Source of protein in the diet (factor with 3 levels: 
    fish meal, soybean meal, dried skim milk)}
  \item{percent}{Protein percentage in the diet (numeric with 4 values:
    9, 12, 15, and 18)}
  \item{conc}{Concentration of free plasma leucine, in mcg/ml}
}
}
\source{
Windels HF (1964) PhD thesis, Univ. of Minnesota. (Reported as
  Problem 10.8 in Oehlert G (2000) \emph{A First Course in Design and
  Analysis of Experiments}, licensed under Creative Commons,
  \url{http://users.stat.umn.edu/~gary/Book.html}.) Observations 7, 22, 23,
  31, 33, and 35 have been omitted, creating a more notable imbalance.
}
\usage{
pigs
}
\description{
A two-factor experiment with some observations lost
}
\examples{
  pigs.lm <- lm(inverse(conc) ~ source + factor(percent), data = pigs)
  emmeans(pigs.lm, "source")
}
\keyword{datasets}
