% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-modify.R
\name{group_modify.dtplyr_step}
\alias{group_modify.dtplyr_step}
\alias{group_map.dtplyr_step}
\title{Apply a function to each group}
\usage{
\method{group_modify}{dtplyr_step}(.tbl, .f, ..., keep = FALSE)

\method{group_map}{dtplyr_step}(.tbl, .f, ..., keep = FALSE)
}
\arguments{
\item{.tbl}{A \code{\link[=lazy_dt]{lazy_dt()}}}

\item{.f}{The name of a two argument function. The first argument is passed
\code{.SD},the data.table representing the current group; the second argument
is passed \code{.BY}, a list giving the current values of the grouping
variables. The function should return a list or data.table.}

\item{...}{Additional arguments passed to \code{.f}}

\item{keep}{Not supported for \link{lazy_dt}.}
}
\value{
\code{group_map()} applies \code{.f} to each group, returning a list.
\code{group_modify()} replaces each group with the results of \code{.f}, returning a
modified \code{\link[=lazy_dt]{lazy_dt()}}.
}
\description{
These are methods for the dplyr \code{\link[=group_map]{group_map()}} and \code{\link[=group_modify]{group_modify()}} generics.
They are both translated to \verb{[.data.table}.
}
\examples{
library(dplyr)

dt <- lazy_dt(mtcars)

dt \%>\%
  group_by(cyl) \%>\%
  group_modify(head, n = 2L)

dt \%>\%
  group_by(cyl) \%>\%
  group_map(head, n = 2L)
}
