% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_graph_weighted.R
\name{is_graph_weighted}
\alias{is_graph_weighted}
\title{Is the graph a weighted graph?}
\usage{
is_graph_weighted(graph)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}
}
\value{
A logical value.
}
\description{
Provides a logical value on whether the graph is weighted. A graph is
considered to be weighted when it contains edges that all have a edge
\code{weight} attribute with numerical values assigned for all edges.
}
\examples{
# Create a graph where the edges have
# a `weight` attribute
graph <-
  create_graph() \%>\%
  add_cycle(n = 5) \%>\%
  select_edges() \%>\%
  set_edge_attrs_ws(
    edge_attr = weight,
    value = c(3, 5, 2, 9, 6)) \%>\%
  clear_selection()

# Determine whether the graph
# is a weighted graph
graph \%>\% is_graph_weighted()

# Create graph where the edges do
# not have a `weight` attribute
graph <-
  create_graph() \%>\%
  add_cycle(n = 5)

# Determine whether this graph
# is weighted
graph \%>\% is_graph_weighted()

}
