% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_radiality.R
\name{get_radiality}
\alias{get_radiality}
\title{Get radiality centrality scores}
\usage{
get_radiality(graph, direction = "all")
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{direction}{Using \code{all} (the default), the search will ignore edge
direction while traversing through the graph. With \code{out}, measurements of
paths will be from a node whereas with \verb{in}, measurements of paths will be
to a node.}
}
\value{
A data frame with radiality centrality scores for each of the nodes.
}
\description{
Get the radiality centrality for all nodes in a graph. These scores describe
the ease to which nodes can reach other nodes.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph() \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the radiality scores for nodes in the graph
graph \%>\%
  get_radiality()

# Add the radiality values
# to the graph as a node
# attribute
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_radiality(.))

# Display the graph's node data frame
graph \%>\%
  get_node_df()

}
