% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf_int.R
\name{conf_int}
\alias{conf_int}
\title{Calculate confidence intervals for all or selected regression coefficients in
a fitted model}
\usage{
conf_int(
  obj,
  vcov,
  level = 0.95,
  test = "Satterthwaite",
  coefs = "All",
  ...,
  p_values = FALSE
)
}
\arguments{
\item{obj}{Fitted model for which to calculate confidence intervals.}

\item{vcov}{Variance covariance matrix estimated using \code{vcovCR} or a
character string specifying which small-sample adjustment should be used to
calculate the variance-covariance.}

\item{level}{Desired coverage level for confidence intervals.}

\item{test}{Character vector specifying which small-sample corrections to
calculate. \code{"z"} returns a z test (i.e., using a standard normal
reference distribution). \code{"naive-t"} returns a t test with \code{m -
1} degrees of freedom, where \code{m} is the number of unique clusters.
\code{"naive-tp"} returns a t test with \code{m - p} degrees of freedom,
where \code{p} is the number of regression coefficients in \code{obj}.
\code{"Satterthwaite"} returns a Satterthwaite correction. Unlike in
\code{coef_test()}, \code{"saddlepoint"} is not currently supported in
\code{conf_int()} because saddlepoint confidence intervals do not have a
closed-form solution.}

\item{coefs}{Character, integer, or logical vector specifying which
coefficients should be tested. The default value \code{"All"} will test all
estimated coefficients.}

\item{...}{Further arguments passed to \code{\link{vcovCR}}, which are only
needed if \code{vcov} is a character string.}

\item{p_values}{Logical indicating whether to report p-values. The default
value is \code{FALSE}.}
}
\value{
A data frame containing estimated regression coefficients, standard
  errors, confidence intervals, and (optionally) p-values.
}
\description{
\code{conf_int} reports confidence intervals for each coefficient estimate in
a fitted linear regression model, using a sandwich estimator for the standard
errors and a small sample correction for the critical values. The
small-sample correction is based on a Satterthwaite approximation.
}
\examples{

data("ChickWeight", package = "datasets")
lm_fit <- lm(weight ~ Diet  * Time, data = ChickWeight)
diet_index <- grepl("Diet.:Time", names(coef(lm_fit)))
conf_int(lm_fit, vcov = "CR2", cluster = ChickWeight$Chick, coefs = diet_index)

V_CR2 <- vcovCR(lm_fit, cluster = ChickWeight$Chick, type = "CR2")
conf_int(lm_fit, vcov = V_CR2, level = .99, coefs = diet_index)

}
\seealso{
\code{\link{vcovCR}}
}
