% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/week-year-week-day.R
\name{year_week_day}
\alias{year_week_day}
\title{Calendar: year-week-day}
\usage{
year_week_day(
  year,
  week = NULL,
  day = NULL,
  hour = NULL,
  minute = NULL,
  second = NULL,
  subsecond = NULL,
  ...,
  start = NULL,
  subsecond_precision = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{week}{\verb{[integer / "last" / NULL]}

The week. Values \verb{[1, 53]} are allowed.

If \code{"last"}, then the last week of the year is returned.}

\item{day}{\verb{[integer / NULL]}

The day of the week. Values \verb{[1, 7]} are allowed, with \verb{1 = start of week}
and \verb{7 = end of week}, in accordance with \code{start}.}

\item{hour}{\verb{[integer / NULL]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer / NULL]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer / NULL]}

The second. Values \verb{[0, 59]} are allowed.}

\item{subsecond}{\verb{[integer / NULL]}

The subsecond. If specified, \code{subsecond_precision} must also be specified
to determine how to interpret the \code{subsecond}.

If using milliseconds, values \verb{[0, 999]} are allowed.

If using microseconds, values \verb{[0, 999999]} are allowed.

If using nanoseconds, values \verb{[0, 999999999]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{start}{\verb{[integer(1) / NULL]}

The day to consider the start of the week. 1 = Sunday and 7 = Saturday.

Use \link{clock_weekdays} for a readable way to specify the start.

If \code{NULL}, a \code{start} of Sunday will be used.}

\item{subsecond_precision}{\verb{[character(1) / NULL]}

The precision to interpret \code{subsecond} as. One of: \code{"millisecond"},
\code{"microsecond"}, or \code{"nanosecond"}.}
}
\value{
A year-week-day calendar vector.
}
\description{
\code{year_week_day()} constructs a calendar from the year, week number,
week day, and the \code{start} of the week.

Using \code{start = clock_weekdays$monday} represents the ISO week calendar and
is equivalent to using \code{\link[=iso_year_week_day]{iso_year_week_day()}}.

Using \code{start = clock_weekdays$sunday} is how Epidemiologists encode their
week-based data.
}
\details{
Fields are recycled against each other using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.

Fields are collected in order until the first \code{NULL} field is located. No
fields after the first \code{NULL} field are used.
}
\examples{
# Year-week
x <- year_week_day(2019:2025, "last")
x

# Start the week on Monday
y <- year_week_day(2019:2025, "last", start = clock_weekdays$monday)
y

# Last days of the year
as_year_month_day(set_day(x, 7))
as_year_month_day(set_day(y, 7))
}
