% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-group}
\alias{date-group}
\alias{date_group.Date}
\title{Group date components}
\usage{
\method{date_group}{Date}(x, precision, ..., n = 1L, invalid = NULL)
}
\arguments{
\item{x}{\verb{[Date]}

A date vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"day"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{n}{\verb{[positive integer(1)]}

A single positive integer specifying a multiple of \code{precision} to use.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
\code{x}, grouped at \code{precision}.
}
\description{
This is a Date method for the \code{\link[=date_group]{date_group()}} generic.

\code{date_group()} groups by a single component of a Date, such as month
of the year, or day of the month.

If you need to group by more complex components, like ISO weeks, or quarters,
convert to a calendar type that contains the component you are interested
in grouping by.
}
\examples{
x <- as.Date("2019-01-01") + -3:5
x

# Group by 2 days of the current month.
# Note that this resets at the beginning of the month, creating day groups
# of [29, 30] [31] [01, 02] [03, 04].
date_group(x, "day", n = 2)

# Group by month
date_group(x, "month")
}
