% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff.R
\name{diff_chr}
\alias{diff_chr}
\title{Compare two character vectors elementwise}
\usage{
diff_chr(old, new, max_dist = Inf)
}
\arguments{
\item{old}{First character vector.}

\item{new}{Second character vector.}

\item{max_dist}{Maximum distance to consider, or \code{Inf} for no limit.
If the LCS edit distance is larger than this, then the function
throws an error with class \code{"cli_diff_max_dist"}. (If you specify
\code{Inf} the real limit is \code{.Machine$integer.max} but to reach this the
function would have to run a very long time.)}
}
\value{
A list that is a \code{cli_diff_chr} object, with a \code{format()} and a
\code{print()} method. You can also access its members:
\itemize{
\item \code{old} and \code{new} are the original inputs,
\item \code{lcs} is a data frame of LCS edit that transform \code{old} into \code{new}.
}

The \code{lcs} data frame has the following columns:
\itemize{
\item \code{operation}: one of \code{"match"}, \code{"delete"} or \code{"insert"}.
\item \code{offset}: offset in \code{old} for matches and deletions, offset in \code{new}
for insertions.
\item \code{length}: length of the operation, i.e. number of matching, deleted
or inserted elements.
\item \code{old_offset}: offset in \code{old} \emph{after} the operation.
\item \code{new_offset}: offset in \code{new} \emph{after} the operation.
}
}
\description{
Its printed output is similar to calling \code{diff -u} at the command
line.
}
\examples{
letters2 <- c("P", "R", "E", letters, "P", "O", "S", "T")
letters2[11:16] <- c("M", "I", "D", "D", "L", "E")
diff_chr(letters, letters2)
}
\seealso{
The diffobj package for a much more comprehensive set of
\code{diff}-like tools.

Other diff functions in cli: 
\code{\link{diff_str}()}
}
\concept{diff functions in cli}
