% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/status-bar.R
\name{cli_status_update}
\alias{cli_status_update}
\title{Update the status bar (superseded)}
\usage{
cli_status_update(
  id = NULL,
  msg = NULL,
  msg_done = NULL,
  msg_failed = NULL,
  .envir = parent.frame()
)
}
\arguments{
\item{id}{Id of the status bar to update. Defaults to the current
status bar container.}

\item{msg}{Text to update the status bar with. \code{NULL} if you don't want
to change it.}

\item{msg_done}{Updated "done" message. \code{NULL} if you don't want to
change it.}

\item{msg_failed}{Updated "failed" message. \code{NULL} if you don't want to
change it.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\value{
Id of the status bar container.
}
\description{
\strong{The \verb{cli_status_*()} functions are superseded by
the \code{\link[=cli_progress_message]{cli_progress_message()}} and \code{\link[=cli_progress_step]{cli_progress_step()}} functions,
because they have a better default behavior.}

Update the status bar
}
\seealso{
This function supports \link[=inline-markup]{inline markup}.

The \code{\link[=cli_progress_message]{cli_progress_message()}} and \code{\link[=cli_progress_step]{cli_progress_step()}}
functions, for a superior API.

Other status bar: 
\code{\link{cli_process_start}()},
\code{\link{cli_status}()},
\code{\link{cli_status_clear}()}

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status}()},
\code{\link{cli_text}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
\concept{status bar}
