% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-files.R
\name{check_files}
\alias{check_files}
\title{Check Files Exist}
\usage{
check_files(x, exists = TRUE, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{exists}{A flag specifying whether the files/directories must (or must not) exist.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks if all files exist (or if exists = FALSE do not exist as files or directories).
}
\examples{
check_files(tempfile("unlikely-that-exists-chk"), exists = FALSE)
try(check_files(tempfile("unlikely-that-exists-chk")))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_dim}()},
\code{\link{check_dirs}()},
\code{\link{check_key}()},
\code{\link{check_names}()},
\code{\link{check_values}()}
}
\concept{check}
