% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-file.R
\name{chk_file}
\alias{chk_file}
\alias{vld_file}
\title{Check File Exists}
\usage{
chk_file(x, x_name = NULL)

vld_file(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if file exists using

\code{vld_string(x) && file.exists(x) && !dir.exists(x)}
}
\section{Functions}{
\itemize{
\item \code{vld_file()}: Validate File Exists

}}
\examples{
# chk_file
try(chk_file(tempfile()))
# vld_file
vld_file(tempfile())
}
\seealso{
\code{\link[=vld_string]{vld_string()}}

\code{\link[=file.exists]{file.exists()}}

\code{\link[=dir.exists]{dir.exists()}}

For more details about the use of this function,
please read the article
\code{vignette("chk-families")}.

Other file_checkers: 
\code{\link{chk_dir}()},
\code{\link{chk_ext}()}
}
\concept{file_checkers}
