# Classes and methods to deal with cell references
Jenny Bryan  
`r Sys.Date()`  

Following Testoft's book Spreadsheet Implementation Technology: Basics and Extensions.

The main class is `ra_ref` which holds a single **r**elative, **a**bsolute, or mixed cell **ref**erence. Two logical indicators, `rowAbs` and `colAbs`, which report whether the row (column) reference is absolute. Also integers `rowRef` and `colRef`, which either hold absolute row and column or, for a relative reference, an offset.

Two other very convenient, but less general forms for holding cell references:

  * as a string
    - in A1 format: e.g. `B4`, `B$4`, `$B4`, `$B$4` (let's assume found in cell `D5`, shall we?)
    - in R1C1 format: e.g. `R[1]C[-2]`, `R4C[-2]`, `R[1]C2`, `R4C2`
  * as an absolute row and colum address

`to_string.ra_ref()` converts a single `ra_ref` to character.  
`as.ra_ref.character()` converts a single cell reference in string form to a `ra_ref` object.  

Note there can be problems converting to/from character, specifically A1 formatted strings, because we don't know the host cell. A relative row or column reference cannot be resolved without knowing the host cell. So this is a source of warnings and `NA`, going both directions. 

The `cell_addr` class is for absolute cell addresses. It's a list with two synchronized, equal length integer vectors, `row` and `col`. It could be a data frame or matrix (and mabye it should be?), but it's not. Methods `[`, `[[`, and `length` exist. Note that a single `cell_addr` object could hold many absolute references.

`to_string.cell_addr` converts a `cell_addr` object to character, in a vectorized way. The format `fo` is an argument. Under the hood, this actually converts each individual cell address into an `ra_ref` object, then calls `to_string` on it, and returns them as character vector.

`as.ra_ref.cell_addr` converts a `cell_addr` object to a `ra_ref` object and is NOT vectorized.

WIP!

