% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A1-to-from-RC.R
\name{R1C1_to_A1}
\alias{R1C1_to_A1}
\title{Convert R1C1 positioning notation to A1 notation}
\usage{
R1C1_to_A1(x, strict = TRUE)
}
\arguments{
\item{x}{vector of cell positions in R1C1 notation}

\item{strict}{logical, affects reading and writing of A1 formatted cell
references. When \code{strict = TRUE}, references must be declared absolute
through the use of dollar signs, e.g., \code{$A$1},  for parsing. When
making a string, \code{strict = TRUE} requests dollar signs for absolute
reference. When \code{strict = FALSE}, pure relative reference strings will
be interpreted as absolute, i.e. \code{A1} and \code{$A$1} are treated the
same. When making a string, \code{strict = FALSE} will cause dollars signs
to be omitted in the reference string.}
}
\value{
character vector of absolute cell references in A1 notation
}
\description{
Convert cell reference strings from R1C1 to A1 format. This only makes sense
for absolute references, such as \code{"R4C2"}. Why? Because otherwise, we'd
have to know the host cell of the reference. Relative and mixed references,
like (\code{"R[3]C[-1]"} and \code{"R[1]C5"}), will therefore return
\code{NA}.
}
\examples{
R1C1_to_A1("R1C1")
R1C1_to_A1("R10C52", strict = FALSE)
R1C1_to_A1(c("R1C1", "R10C52", "RC4", "R[-3]C[9]"))
}

