% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_pairwise.R
\name{ard_pairwise}
\alias{ard_pairwise}
\title{Pairwise ARD}
\usage{
ard_pairwise(data, variable, .f, include = NULL)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variable}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
Column to perform pairwise analyses for.}

\item{.f}{(\code{function})\cr
a function that creates ARDs. The function accepts a single argument and
a subset of \code{data} will be passed including the two levels of \code{variable}
for the pairwise analysis.}

\item{include}{(\code{vector})\cr
a vector of levels of the \code{variable} column to include in comparisons.
Pairwise comparisons will only be performed for pairs that have a level
specified here. Default is \code{NULL} and all pairwise computations are included.}
}
\value{
list of ARDs
}
\description{
Utility to perform pairwise comparisons.
}
\examples{
ard_pairwise(
  ADSL,
  variable = ARM,
  .f = \(df) {
    ard_complex(
      df,
      variables = AGE,
      statistic = ~ list(ttest = \(x, data, ...) t.test(x ~ data$ARM)[c("statistic", "p.value")])
    )
  },
  include = "Placebo" # only include comparisons to the "Placebo" group
)
}
