% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot-tidiers.R
\name{tidy.boot}
\alias{tidy.boot}
\alias{boot_tidiers}
\title{Tidy a(n) boot object}
\usage{
\method{tidy}{boot}(
  x,
  conf.int = FALSE,
  conf.level = 0.95,
  conf.method = c("perc", "bca", "basic", "norm"),
  ...
)
}
\arguments{
\item{x}{A \code{\link[boot:boot]{boot::boot()}} object.}

\item{conf.int}{Logical indicating whether or not to include a confidence
interval in the tidied output. Defaults to \code{FALSE}.}

\item{conf.level}{The confidence level to use for the confidence interval
if \code{conf.int = TRUE}. Must be strictly greater than 0 and less than 1.
Defaults to 0.95, which corresponds to a 95 percent confidence interval.}

\item{conf.method}{Passed to the \code{type} argument of \code{\link[boot:boot.ci]{boot::boot.ci()}}.
Defaults to \code{"perc"}. The allowed types are \code{"perc"}, \code{"basic"},
\code{"bca"}, and \code{"norm"}. Does not support \code{"stud"} or \code{"all"}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
If weights were provided to the \code{boot} function, an \code{estimate}
column is included showing the weighted bootstrap estimate, and the
standard error is of that estimate.

If there are no original statistics in the "boot" object, such as with a
call to \code{tsboot} with \code{orig.t = FALSE}, the \code{original}
and \code{statistic} columns are omitted, and only \code{estimate} and
\code{std.error} columns shown.
}
\examples{

if (requireNamespace("boot", quietly = TRUE)) {

library(boot)

clotting <- data.frame(
  u = c(5, 10, 15, 20, 30, 40, 60, 80, 100),
  lot1 = c(118, 58, 42, 35, 27, 25, 21, 19, 18),
  lot2 = c(69, 35, 26, 21, 18, 16, 13, 12, 12)
)

g1 <- glm(lot2 ~ log(u), data = clotting, family = Gamma)

bootfun <- function(d, i) {
  coef(update(g1, data = d[i, ]))
}

bootres <- boot(clotting, bootfun, R = 999)
tidy(g1, conf.int = TRUE)
tidy(bootres, conf.int = TRUE)

}

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[boot:boot]{boot::boot()}}, \code{\link[boot:tsboot]{boot::tsboot()}}, \code{\link[boot:boot.ci]{boot::boot.ci()}},
\code{\link[rsample:bootstraps]{rsample::bootstraps()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{bias}{Bias of the statistic.}
  \item{std.error}{The standard error of the regression term.}
  \item{term}{The name of the regression term.}
  \item{statistic}{Original value of the statistic.}

}
