% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypothesis.R
\name{density_ratio}
\alias{density_ratio}
\title{Compute Density Ratios}
\usage{
density_ratio(x, y = NULL, point = 0, n = 4096, ...)
}
\arguments{
\item{x}{Vector of draws from the first distribution, usually the posterior
distribution of the quantity of interest.}

\item{y}{Optional vector of draws from the second distribution, usually the
prior distribution of the quantity of interest. If \code{NULL} (the
default), only the density of \code{x} will be evaluated.}

\item{point}{Numeric values at which to evaluate and compare the densities.
Defaults to \code{0}.}

\item{n}{Single numeric value. Influences the accuracy of the density
estimation. See \code{\link[stats:density]{density}} for details.}

\item{...}{Further arguments passed to \code{\link[stats:density]{density}}.}
}
\value{
A vector of length equal to \code{length(point)}. If \code{y} is
  provided, the density ratio of \code{x} against \code{y} is returned. Else,
  only the density of \code{x} is returned.
}
\description{
Compute the ratio of two densities at given points based on draws of the
corresponding distributions.
}
\details{
In order to achieve sufficient accuracy in the density estimation,
  more draws than usual are required. That is you may need an effective
  sample size of 10,000 or more to reliably estimate the densities.
}
\examples{
x <- rnorm(10000)
y <- rnorm(10000, mean = 1)
density_ratio(x, y, point = c(0, 1))

}
