% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{LogisticNormal}
\alias{LogisticNormal}
\alias{dlogistic_normal}
\alias{rlogistic_normal}
\title{The (Multivariate) Logistic Normal Distribution}
\usage{
dlogistic_normal(x, mu, Sigma, refcat = 1, log = FALSE, check = FALSE)

rlogistic_normal(n, mu, Sigma, refcat = 1, check = FALSE)
}
\arguments{
\item{x}{Vector or matrix of quantiles. If \code{x} is a matrix,
each row is taken to be a quantile.}

\item{mu}{Mean vector with length equal to the number of dimensions.}

\item{Sigma}{Covariance matrix.}

\item{refcat}{A single integer indicating the reference category.
Defaults to \code{1}.}

\item{log}{Logical; If \code{TRUE}, values are returned on the log scale.}

\item{check}{Logical; Indicates whether several input checks
should be performed. Defaults to \code{FALSE} to improve
efficiency.}

\item{n}{Number of draws to sample from the distribution.}
}
\description{
Density function and random generation for the (multivariate) logistic normal
distribution with latent mean vector \code{mu} and covariance matrix \code{Sigma}.
}
