% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkutil.R
\name{chunk}
\alias{chunk}
\alias{chunk.default}
\title{Methods for chunked range index}
\usage{
chunk(x = NULL, ...)

\method{chunk}{default}(x = NULL, ..., RECORDBYTES = NULL, BATCHBYTES = NULL)
}
\arguments{
\item{x}{the object along we want chunks}

\item{...}{further arguments passed to \code{\link[=chunks]{chunks()}}}

\item{RECORDBYTES}{integer scalar representing the bytes needed to process a single
element of the boolean vector (default 4 bytes for logical)}

\item{BATCHBYTES}{integer scalar limiting the number of bytes to be processed in one
chunk, default from \code{getOption("ffbatchbytes")} if not null, otherwise 16777216}
}
\value{
returns a named list of \code{\link[=ri]{ri()}} objects
representing chunks of subscripts
}
\description{
Calls \code{\link[=chunks]{chunks()}} to create a sequence of range indexes along the object which causes
the method dispatch.
}
\details{
\code{chunk} is generic, the default method is described here, other methods
that automatically consider RAM needs are provided with package 'ff', see
for example \code{\link[ff:chunk.ffdf]{ff::chunk.ffdf()}}
}
\section{Methods (by class)}{
\itemize{
\item \code{chunk(default)}: default vector method

}}
\section{available methods}{
 \code{chunk.default}, \code{\link[ff:chunk.ffdf]{ff::chunk.ff_vector()}},
\code{\link[ff:chunk.ffdf]{ff::chunk.ffdf()}}
}

\examples{
  chunk(complex(1e7))
  chunk(raw(1e7))
  chunk(raw(1e7), length=3)

  chunks(1, 10, 3)
  # no longer do
  chunk(1, 100, 10)
  # but for bckward compatibility this works
  chunk(from=1, to=100, by=10)

}
\seealso{
\code{\link[=chunks]{chunks()}}, \code{\link[=ri]{ri()}}, \code{\link[base:seq]{seq()}}, \code{\link[=bbatch]{bbatch()}}
}
\author{
Jens Oehlschlägel
}
\keyword{data}
