% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integerutil.R
\name{copy_vector}
\alias{copy_vector}
\title{Copy atomic R vector}
\usage{
copy_vector(x, revx = FALSE)
}
\arguments{
\item{x}{an R vector}

\item{revx}{default \code{FALSE}, set to \code{TRUE} to reverse the elements in 'x'}
}
\value{
copied R vector
}
\description{
Creates a true copy of the underlying C-vector -- dropping all attributes -- and optionally reverses the direction of the elements.
}
\details{
This can be substantially faster than \code{duplicate(as.vector(unclass(x)))}
}
\examples{
x <- factor(letters)
y <- x
z <- copy_vector(x)
still.identical(x,y)
still.identical(x,z)
str(x)
str(y)
str(z)
}
\seealso{
\code{\link{clone}}, \code{\link{still.identical}},  \code{\link{reverse_vector}}
}
