% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/killJobs.R
\name{killJobs}
\alias{killJobs}
\title{Kill some jobs on the batch system.}
\usage{
killJobs(reg, ids, progressbar = TRUE)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Ids of jobs to kill.
Default is none.}

\item{progressbar}{[\code{logical(1)}]\cr
Set to \code{FALSE} to disable the progress bar.
To disable all progress bars, see \code{\link[BBmisc]{makeProgressBar}}.}
}
\value{
[\code{integer}]. Ids of killed jobs.
}
\description{
Kill jobs which have already been submitted to the batch system.
If a job is killed its internal state is reset as if it had not been submitted at all.

The function informs if
(a) the job you want to kill has not been submitted,
(b) the job has already terminated,
(c) for some reason no batch job id is available.
In all 3 cases above, nothing is changed for the state of this job and no call
to the internal kill cluster function is generated.

In case of an error when killing, the function tries - after a short sleep - to kill the remaining
batch jobs again. If this fails again for some jobs, the function gives up. Only jobs that could be
killed are reset in the DB.
}
\examples{
\dontrun{
reg = makeRegistry(id = "BatchJobsExample", file.dir = tempfile(), seed = 123)
f = function(x) Sys.sleep(x)
batchMap(reg, f, 1:10 + 5)
submitJobs(reg)
waitForJobs(reg)

# kill all jobs currently _running_
killJobs(reg, findRunning(reg))
# kill all jobs queued or running
killJobs(reg, findNotTerminated(reg))
}
}
\seealso{
Other debug: \code{\link{debugMulticore}},
  \code{\link{debugSSH}}, \code{\link{getErrorMessages}},
  \code{\link{getJobInfo}}, \code{\link{getLogFiles}},
  \code{\link{grepLogs}}, \code{\link{resetJobs}},
  \code{\link{setJobFunction}}, \code{\link{showLog}},
  \code{\link{testJob}}
}
\concept{debug}
