% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{merge_dots_with_list}
\alias{merge_dots_with_list}
\title{Merge ellipsis args with a list.}
\usage{
merge_dots_with_list(..., l = list(), warn_on_dupes = TRUE,
  allow_unnamed_elements = FALSE)
}
\arguments{
\item{...}{Some inputs.}

\item{l}{A list.}

\item{warn_on_dupes}{\code{TRUE} or \code{FALSE}.  Should a warning be given 
if both \code{x} and \code{y} have elements with the same name.  See note.}

\item{allow_unnamed_elements}{\code{TRUE} or \code{FALSE}. Should unnamed
elements be allowed?}
}
\value{
A list containing the merged inputs.
}
\description{
Merges variable length ellipsis arguments to a function with a list argument.
}
\note{
If any arguments are present in both the \code{...} and \code{l} 
arguments, the \code{...} version takes preference, and a warning is thrown.
}
\examples{
merge_dots_with_list(
  foo = 1, 
  bar = 2, 
  baz = 3, 
  l = list(foo = 4, baz = 5, quux = 6)
)
}
\seealso{
\code{\link{merge.list}}, \code{\link[base]{merge}}
}

