% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComBat.R
\name{ComBat}
\alias{ComBat}
\title{Adjust for batch effects using an empirical Bayes framework}
\usage{
ComBat(
  dat,
  batch,
  mod = NULL,
  par.prior = TRUE,
  prior.plots = FALSE,
  mean.only = FALSE,
  ref.batch = NULL,
  BPPARAM = bpparam("SerialParam")
)
}
\arguments{
\item{dat}{Genomic measure matrix (dimensions probe x sample) - for example, expression matrix}

\item{batch}{{Batch covariate (only one batch allowed)}}

\item{mod}{Model matrix for outcome of interest and other covariates besides batch}

\item{par.prior}{(Optional) TRUE indicates parametric adjustments will be used, FALSE indicates non-parametric adjustments will be used}

\item{prior.plots}{(Optional) TRUE give prior plots with black as a kernel estimate of the empirical batch effect density and red as the parametric}

\item{mean.only}{(Optional) FALSE If TRUE ComBat only corrects the mean of the batch effect (no scale adjustment)}

\item{ref.batch}{(Optional) NULL If given, will use the selected batch as a reference for batch adjustment.}

\item{BPPARAM}{(Optional) BiocParallelParam for parallel operation}
}
\value{
data A probe x sample genomic measure matrix, adjusted for batch effects.
}
\description{
ComBat allows users to adjust for batch effects in datasets where the batch covariate is known, using methodology
described in Johnson et al. 2007. It uses either parametric or non-parametric empirical Bayes frameworks for adjusting data for
batch effects.  Users are returned an expression matrix that has been corrected for batch effects. The input
data are assumed to be cleaned and normalized before batch effect removal.
}
\examples{
library(bladderbatch)
data(bladderdata)
dat <- bladderEset[1:50,]

pheno = pData(dat)
edata = exprs(dat)
batch = pheno$batch
mod = model.matrix(~as.factor(cancer), data=pheno)

# parametric adjustment
combat_edata1 = ComBat(dat=edata, batch=batch, mod=NULL, par.prior=TRUE, prior.plots=FALSE)

# non-parametric adjustment, mean-only version
combat_edata2 = ComBat(dat=edata, batch=batch, mod=NULL, par.prior=FALSE, mean.only=TRUE)

# reference-batch version, with covariates
combat_edata3 = ComBat(dat=edata, batch=batch, mod=mod, par.prior=TRUE, ref.batch=3)

}
