% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.R
\docType{methods}
\name{SCE-combine}
\alias{SCE-combine}
\alias{cbind,SingleCellExperiment-method}
\alias{rbind,SingleCellExperiment-method}
\alias{combineCols,SingleCellExperiment-method}
\alias{[,SingleCellExperiment,ANY-method}
\alias{[,SingleCellExperiment,ANY,ANY-method}
\alias{[,SingleCellExperiment,ANY,ANY,ANY-method}
\alias{[<-,SingleCellExperiment,ANY,ANY,SingleCellExperiment-method}
\title{Combining or subsetting SingleCellExperiment objects}
\description{
An overview of methods to combine multiple \linkS4class{SingleCellExperiment} objects by row or column,
or to subset a SingleCellExperiment by row or column.
These methods are useful for ensuring that all data fields remain synchronized
when cells or genes are added or removed.
}
\section{Combining}{

In the following code snippets, \code{...} contains one or more \linkS4class{SingleCellExperiment} objects.
\describe{
\item{\code{rbind(..., deparse.level=1)}:}{Returns a SingleCellExperiment where all objects in \code{...} are combined row-wise,
i.e., rows in successive objects are appended to the first object.

Refer to \code{?"\link{rbind,SummarizedExperiment-method}"} for details on how metadata is combined in the output object.
Refer to \code{?\link[base]{rbind}} for the interpretation of \code{deparse.level}.

Note that all objects in \code{...} must have the exact same values for \code{\link{reducedDims}} and \code{\link{altExps}}.
Any \code{\link{sizeFactors}} should either be \code{NULL} or contain the same values across objects.
}
\item{\code{cbind(..., deparse.level=1)}:}{Returns a SingleCellExperiment where
all objects in \code{...} are combined column-wise,
i.e., columns in successive objects are appended to the first object.

Each object \code{x} in \code{...} must have the same values of \code{\link{reducedDimNames}(x)} (though they can be unordered).
Dimensionality reduction results with the same name across objects
will be combined row-wise to create the corresponding entry in the output object.

Each object \code{x} in \code{...} must have the same values of \code{\link{altExpNames}(x)} (though they can be unordered).
Alternative Experiments with the same name across objects
will be combined column-wise to create the corresponding entry in the output object.

\code{\link{sizeFactors}} should be either set to \code{NULL} in all objects, or set to a numeric vector in all objects.

Refer to \code{?"\link{cbind,SummarizedExperiment-method}"} for details on how metadata is combined in the output object.
Refer to \code{?\link[base]{cbind}} for the interpretation of \code{deparse.level}.
}
}

In the following code snippets, \code{x} is a SingleCellExperiment and \code{...} contains multiple SingleCellExperiment objects.
\describe{
\item{\code{combineCols(x, ..., delayed=TRUE, fill=NA, use.names=TRUE)}:}{
Returns a SingleCellExperiment where all objects are flexibly combined by column.
The assays and \code{\link{colData}} are combined as described in \code{?"\link{combineCols,SummarizedExperiment-method}"},
where assays or DataFrame columns missing in any given object are filled in with missing values before combining.

Entries of the \code{\link{reducedDims}} with the same name across objects are combined by row.
If a dimensionality reduction result is not present for a particular SingleCellExperiment, it is represented by a matrix of \code{NA} values instead.
If corresponding \code{\link{reducedDim}} entries cannot be combined, e.g., due to inconsistent dimensions, they are omitted from the \code{\link{reducedDims}} of the output object with a warning.

Entries of the \code{\link{altExps}} with the same name across objects are combined by column using the relevant \code{\link{combineCols}} method.
If a named entry is not present for a particular SingleCellExperiment, it is represented by a SummarizedExperiment with a single assay full of \code{fill} values.
If entries cannot be combined, e.g., due to inconsistent dimensions, they are omitted from the \code{\link{altExps}} of the output object with a warning.

Entries of the \code{\link{colPairs}} with the same name across objects are concatenated together after adjusting the indices for each column's new position in the combined object.
If a named entry is not present for a particular SingleCellExperiments, it is assumed to contribute no column pairings and is ignored.

Entries of the \code{\link{rowPairs}} with the same name should be identical across objects if \code{use.names=FALSE}.
If \code{use.names=TRUE}, we attempt to merge together entries with the same name by taking the union of all column pairings.
However, if the same cell has a different set of pairings across objects, a warning is raised and we fall back to the \code{\link{rowPair}} entry from the first object.
}
}
}

\section{Subsetting}{

In the following code snippets, \code{x} is a \linkS4class{SingleCellExperiment} object.
\describe{
\item{\code{x[i, j, ..., drop=TRUE]}:}{Returns a SingleCellExperiment containing the
specified rows \code{i} and columns \code{j}.

\code{i} and \code{j} can be a logical, integer or character vector of subscripts,
indicating the rows and columns respectively to retain.
Either can be missing, in which case subsetting is only performed in the specified dimension.
If both are missing, no subsetting is performed.

Arguments in \code{...} and \code{drop} are passed to to \code{\link{[,SummarizedExperiment-method}}.}
\item{\code{x[i, j, ...] <- value}:}{Replaces all data for rows \code{i} and columns {j}
with the corresponding fields in a SingleCellExperiment \code{value}.

\code{i} and \code{j} can be a logical, integer or character vector of subscripts,
indicating the rows and columns respectively to replace.
Either can be missing, in which case replacement is only performed in the specified dimension.
If both are missing, \code{x} is replaced entirely with \code{value}.

If \code{j} is specified, \code{value} is expected to have the same name and order of \code{\link{reducedDimNames}}
and \code{\link{altExpNames}} as \code{x}.
If \code{sizeFactors} is set for \code{x}, it should also be set for \code{value}.

Arguments in \code{...} are passed to the corresponding \linkS4class{SummarizedExperiment} method.}
}
}

\examples{
example(SingleCellExperiment, echo=FALSE) # using the class example

# Combining:
rbind(sce, sce)
cbind(sce, sce)

# Subsetting:
sce[1:10,]
sce[,1:5]

sce2 <- sce
sce2[1:10,] <- sce[11:20,]

# Can also use subset()
sce$WHEE <- sample(LETTERS, ncol(sce), replace=TRUE)
subset(sce, , WHEE=="A")

# Can also use split()
split(sce, sample(LETTERS, nrow(sce), replace=TRUE))

}
\author{
Aaron Lun
}
