\name{spViewPerFeature}
\alias{spViewPerFeature}

\title{
Tools to visualize genomic data
}
\description{
Use \code{Snapshot}-class to visualize a specific region of genomic data
}
\usage{
spViewPerFeature(GRL, name, files, ignore.strand=FALSE,
                 multi.levels = FALSE, fac=character(0L), ...) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{GRL}{Object \code{GRangeList} containing annotation of
    genomic data. It can be generated by applying  \code{exonsBy()} or
    \code{transcriptsBy()} to a \code{TranscriptDb} instance. See
    examples below.}
  
  \item{name}{Character(1) specifying which element in \code{GRL}
    to be visualized.} 

  \item{files}{Charactor() or \code{BamFileList} specifying the file(s)
    to be visualized. If multiple files, local metadata of the files can
    be hold by setting a \code{DataFrame} (values(files) <-
    DataFrame(...)). See examples below.} 
  
  \item{ignore.strand}{Logical(1) indicating whether to ignore the
    strand of the genomic data.} 

  \item{multi.levels}{Logical(1) indicating whether to plot the
    coverage of  multiple files on different panels. If \code{FALSE},
    the mean coverage of multiple files would be plotted. }

   \item{fac}{Character(1) indicating which column of local metadata
     (\code{elementMetatdata()}) should be used to group the
     samples. Ignore}
   
  \item{\dots}{Arguments used for creating a \code{\link{Snapshot}} object.}
  
}

\value{A \code{Snapshot} instance}

\author{Chao-Jen Wong \email{cwon2@fhcrc.org}}

\seealso{
\code{\link{Snapshot}}
}
\examples{
## Example 1
library(GenomicFeatures)
txdbFile <- system.file("extdata", "sacCer2_sgdGene.sqlite",
                         package="yeastNagalakshmi")

## either use a txdb file quaried from UCSC or use existing TxDb packages.
txdb <- loadDb(txdbFile)

grl <- exonsBy(txdb, by="gene")
file <- system.file("extdata", "SRR002051.chrI-V.bam",
                         package="yeastNagalakshmi")
s <- spViewPerFeature(GRL=grl, name="YAL001C", files=file)

## Example 2
## multi-files: using 'BamFileList' and setting up the 'DataFrame'
## holding the phenotype data

bfiles <- BamFileList(c(a=file, b=file))
values(bfiles) <- DataFrame(sampleGroup=factor(c("normal", "tumor")))
values(bfiles)

s <- spViewPerFeature(GRL=grl, name="YAL001C",
                      files=bfiles, multi.levels=TRUE, fac="sampleGroup")

}

